<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PharmaEase</title>
    <link rel="stylesheet" href="style.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Days+One&family=Lexend:wght@100..900&family=Teko:wght@300..700&display=swap');

        /* Popup Styles */
        .popup {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            display: none;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }

        .popup-content {
            background: white;
            padding: 30px;
            border-radius: 10px;
            width: 350px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            font-family: 'Lexend', sans-serif;
            position: relative;
        }

        .popup h3 {
            color: #408C67;
            margin-bottom: 25px;
            text-align: center;
            font-size: 1.5rem;
        }

        .popup input {
            width: 100%;
            padding: 12px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 1rem;
            box-sizing: border-box;
        }

        .popup button[type="submit"] {
            background-color: #408C67;
            color: white;
            border: none;
            padding: 10px 10px;
            border-radius: 5px;
            cursor: pointer;
            width: 40%;
            font-size: 1rem;
            transition: background-color 0.3s;
            display: block;
            margin: 0 auto;
        }

        .popup button[type="submit"]:hover {
            background-color: #2E6B4F;
        }

        .close {
            position: absolute;
            top: 10px;
            right: 15px;
            font-size: 24px;
            font-weight: bold;
            color: #718096;
            cursor: pointer;
        }

        .close:hover {
            color: #2d3748;
        }

        #errorMsg {
            color: #e53e3e;
            display: none;
            margin-top: -10px;
            margin-bottom: 15px;
            font-size: 0.9rem;
        }

        .check-discount-offer {
            padding: 10px 15px;
            background-color: #408C67;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        .check-discount-offer:hover {
            background-color: #45a049;
        }

        .modal-buttons {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 15px;
        }

        .add-to-cart-btn,
        .view-cart-btn {
            background-color: #408C67;
            /* same green color */
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 5px;
            cursor: pointer;
            font-size: 15px;
            transition: background-color 0.3s;
        }

        .add-to-cart-btn:hover,
        .view-cart-btn:hover {
            background-color: #2E6B4F;
            /* darker green on hover */
        }
    </style>
</head>

<body>
    <section id="homebg">
        <nav class="navbar">
            <div class="navbar-container">
                <a href="#" class="navbar-brand">
                    <img src="Frame 6.png" alt="PharmaEase Logo">
                    <span>PharmaEase</span> </a>
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a href="#" class="nav-link">Home</a>
                    </li>
                    <li class="nav-item">
                        <a href="cart.php" class="nav-link">Cart</a>
                    </li>
                    <li class="nav-item">
                        <a href="users.php" class="nav-link">User</a>
                    </li>
                    <li class="nav-item">
                        <a href="index.php" class="nav-link">Logout</a>
                    </li>
                </ul>
            </div>
        </nav>
        <section id="welcome">
            <h1>Welcome to PharmaEase <br>
                A service you can trust</h1>

            <div class="frame-11">
                <button class="check-discount-offer" onclick="openPopup()">Check Discount Offer</button>

                <!-- Popup Form (hidden by default) -->
                <div id="phonePopup" class="popup">
                    <div class="popup-content">
                        <span class="close popup-close" onclick="closePopup()">&times;</span>
                        <h3>Enter Your 11-Digit Mobile Number</h3>
                        <form id="discountForm" method="post" action="../../controller/sms.php">
                            <input type="text" id="phoneInput" name="phoneNumber" placeholder="e.g. 09123456789"
                                maxlength="11" inputmode="numeric" required>
                            <p id="errorMsg">Please enter exactly 11 digits</p>
                            <button type="submit" onclick="success()">Check Offers</button>
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <section id="whitespace">
            <br><br><br><br><br><br><br><br>
            <br><br><br><br><br><br><br><br>
        </section>

    </section>
    <section id="navigation">
        <div class="navbox" id="navbox1">
            <h2>Over the Counter</h2>
            <p>No prescription needed, our over-the-counter medicines and health products help you handle common issues
                like headaches, allergies, colds, and more. Safe, trusted brands delivered right to your door.</p>

        </div>
        <div class="navbox" id="navbox2">
            <h2>Prescription Needed</h2>
            <p>Prescription required, our selection of trusted medications is here to support your health, from chronic
                conditions to specific treatments. Safe, reliable, and delivered to your door with care.
            </p>

        </div>
        <div class="navbox" id="navbox3">
            <h2>Herbal Medicines</h2>
            <p>Natural healing made easy, our herbal medicines are crafted from trusted plant-based ingredients to
                support your health and wellness, the natural way. Safe, effective, and delivered to your door.
            </p>

        </div>
    </section>
    <section id="pos">
        <h1 id="popular">Popular Medicine</h1>
    </section>
    <section id="list">
        <div class="medicine-list">
            <img class="frame-13" src="Frame 13.png" />
            <div class="medtitle">Paracetamol Biogesic</div>
            <div class="medprice">₱6.45</div>
            <div class="meddesc">
                Biogesic is used as a pain reliever and fever reducer, commonly used for conditions such as headache,
                muscle pain, and dental pain.</div>
            <button title="Add New" class="add-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                    class="button-icon">
                    <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z"
                        stroke-width="1.5"></path>
                    <path d="M8 12H16" stroke-width="1.5"></path>
                    <path d="M12 16V8" stroke-width="1.5"></path>
                </svg>
            </button>

        </div>
        <div class="medicine-list">
            <img class="frame-13" src="Frame 14.png" />
            <div class="medtitle">BioFlu</div>
            <div class="medprice">₱6.45</div>
            <div class="meddesc">
                This medicine is used for the relief of clogged nose, runny nose, cough from postnasal drip, itchy &
                watery eyes, sneezing, & headache.</div>
            <button title="Add New" class="add-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                    class="button-icon">
                    <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z"
                        stroke-width="1.5"></path>
                    <path d="M8 12H16" stroke-width="1.5"></path>
                    <path d="M12 16V8" stroke-width="1.5"></path>
                </svg>
            </button>
        </div>
        <div class="medicine-list">
            <img class="frame-13" src="Frame 15.png" />
            <div class="medtitle">Cetirizine</div>
            <div class="medprice">₱8.45</div>
            <div class="meddesc">
                Cetirizine is an antihistamine that is taken to help treat allergy symptoms, such as a runny nose, itchy
                or watery eyes, & sneezing.
            </div>
            <button title="Add New" class="add-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                    class="button-icon">
                    <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z"
                        stroke-width="1.5"></path>
                    <path d="M8 12H16" stroke-width="1.5"></path>
                    <path d="M12 16V8" stroke-width="1.5"></path>
                </svg>
            </button>
        </div>
        <div class="medicine-list">
            <img class="frame-13" src="Frame 16.png" />
            <div class="medtitle">Celebrex</div>
            <div class="medprice">₱17.25</div>
            <div class="meddesc">
                Celecoxib Capsules. Celebrex® (celecoxib) is a medication that treats mild to moderate pain and
                inflammation.
            </div>
            <button title="Add New" class="add-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                    class="button-icon">
                    <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z"
                        stroke-width="1.5"></path>
                    <path d="M8 12H16" stroke-width="1.5"></path>
                    <path d="M12 16V8" stroke-width="1.5"></path>
                </svg>
            </button>
        </div>
        <div class="medicine-list">
            <img class="frame-13" src="Frame 17.png" />
            <div class="medtitle">Metformin</div>
            <div class="medprice">₱13.00</div>
            <div class="meddesc">
                Metformin is used to treat high blood sugar levels that are caused by a type of diabetes mellitus or
                sugar diabetes called type 2 diabetes.
            </div>
            <button title="Add New" class="add-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                    class="button-icon">
                    <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z"
                        stroke-width="1.5"></path>
                    <path d="M8 12H16" stroke-width="1.5"></path>
                    <path d="M12 16V8" stroke-width="1.5"></path>
                </svg>
            </button>
        </div>
        <div class="medicine-list">
            <img class="frame-13" src="Frame 18.png" />
            <div class="medtitle">Medicol Ibuprofen</div>
            <div class="medprice">₱24.00</div>
            <div class="meddesc">
                Ibuprofen Medicol is used to help treat various types of pain such as headache, migraine, toothache,
                dysmenorrhea, body pain, and arthritis.
            </div>
            <button title="Add New" class="add-button">
                <svg xmlns="http://www.w3.org/2000/svg" width="50px" height="50px" viewBox="0 0 24 24"
                    class="button-icon">
                    <path d="M12 22C17.5 22 22 17.5 22 12C22 6.5 17.5 2 12 2C6.5 2 2 6.5 2 12C2 17.5 6.5 22 12 22Z"
                        stroke-width="1.5"></path>
                    <path d="M8 12H16" stroke-width="1.5"></path>
                    <path d="M12 16V8" stroke-width="1.5"></path>
                </svg>
            </button>
        </div>
    </section>
    <div id="addModal" class="modal">
        <div class="modal-content">
            <span class="close modal-close">&larr;</span>
            <h2>Add to Cart</h2>
            <div class="modal-body">
                <div class="product-info">
                    <img id="modalImage" src="" alt="Medicine" class="modal-image">
                    <div class="product-details">
                        <h3 id="modalTitle"></h3>
                        <p id="modalPrice"></p>
                    </div>
                    <div class="quantity-selector">
                        <div class="quantity-controls">
                            <button class="quantity-btn" onclick="decrementQuantity()">-</button>
                            <input type="number" id="quantity" value="1" min="1">
                            <button class="quantity-btn" onclick="incrementQuantity()">+</button>
                        </div>
                    </div>
                </div>
                <div class="modal-buttons">
                    <button class="add-to-cart-btn">Add to Cart</button>
                    <button class="view-cart-btn" onclick="location.href='cart.php'">View Cart</button>
                </div>
            </div>
        </div>
        <script>

            // Popup functionality
            function openPopup() {
                document.getElementById('phonePopup').style.display = 'flex';
                document.getElementById('errorMsg').style.display = 'none';
            }

            function closePopup() {
                document.getElementById('phonePopup').style.display = 'none';
            }

            function validatePhoneNumber(event) {
                event.preventDefault();
                const phoneNumber = document.getElementById('phoneInput').value;
                const errorElement = document.getElementById('errorMsg');

                // Check if input is exactly 11 digits
                if (/^\d{11}$/.test(phoneNumber)) {
                    // Submit the form if valid
                    document.getElementById('discountForm').submit();
                    return true;
                } else {
                    // Show error message
                    errorElement.style.display = 'block';
                    return false;
                }
            }
            function success() {
                alert("Success! Check your phone for the discount offer.");
            }
            // Close popup when clicking outside of it
            window.onclick = function (event) {
                const popup = document.getElementById('phonePopup');
                if (event.target == popup) {
                    closePopup();
                }
            }

            // Restrict input to numbers only
            document.getElementById('phoneInput').addEventListener('input', function (e) {
                this.value = this.value.replace(/[^0-9]/g, '');
            });

            // Attach form submission handler
            document.getElementById('discountForm').addEventListener('submit', validatePhoneNumber);

            // Handle opening the Add to Cart modal
            const addButtons = document.querySelectorAll('.add-button');
            const modal = document.getElementById('addModal');
            const modalImage = document.getElementById('modalImage');
            const modalTitle = document.getElementById('modalTitle');
            const modalPrice = document.getElementById('modalPrice');
            const quantityInput = document.getElementById('quantity');
            const modalClose = document.querySelector('.modal-close');
            const addCartBtn = document.querySelector('.add-to-cart-btn');


            addButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const medicineCard = this.closest('.medicine-list');
                    const imageSrc = medicineCard.querySelector('img').getAttribute('src');
                    const title = medicineCard.querySelector('.medtitle').textContent;
                    const price = medicineCard.querySelector('.medprice').textContent;

                    modalImage.setAttribute('src', imageSrc);
                    modalTitle.textContent = title;
                    modalPrice.textContent = price;
                    quantityInput.value = 1;

                    modal.style.display = 'block';
                });
            });
            // Add click event to all add buttons
            addButtons.forEach(button => {
                button.addEventListener('click', (e) => {
                    const medicineItem = e.target.closest('.medicine-list');
                    openModal(medicineItem);
                });
            });
            // Close modal
            modalClose.addEventListener('click', () => {
                modal.style.display = 'none';
            });

            // Quantity Controls
            function incrementQuantity() {
                quantityInput.value = parseInt(quantityInput.value) + 1;
            }

            function decrementQuantity() {
                if (parseInt(quantityInput.value) > 1) {
                    quantityInput.value = parseInt(quantityInput.value) - 1;
                }
            }

            // Optional: Close modal when clicking outside the modal content
            window.addEventListener('click', function (e) {
                if (e.target === modal) {
                    modal.style.display = 'none';
                }
            });

            // Add to cart button
            document.querySelector('.add-to-cart-btn').addEventListener('click', () => {
                const title = document.getElementById('modalTitle').textContent;
                const price = document.getElementById('modalPrice').textContent;
                const quantity = parseInt(quantityInput.value);

                // Get existing cart or empty array
                let cart = JSON.parse(localStorage.getItem('cart')) || [];

                // Check if item already in cart
                const index = cart.findIndex(item => item.title === title);
                if (index > -1) {
                    // Update quantity if exists
                    cart[index].quantity += quantity;
                } else {
                    // Add new item
                    cart.push({ title, price, quantity });
                }

                // Save back to localStorage
                localStorage.setItem('cart', JSON.stringify(cart));

                alert(`Added ${quantity} ${title} to cart`);

                modal.style.display = 'none';


            });
        </script>
</body>

</html>